VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "KPCI-3102/04 AO Level Control Panel"
   ClientHeight    =   2130
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4245
   Icon            =   "Kpci3102AOExample.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   2130
   ScaleWidth      =   4245
   StartUpPosition =   1  'CenterOwner
   Begin VB.OptionButton Option2 
      Caption         =   "Channel 1"
      Height          =   495
      Left            =   360
      TabIndex        =   8
      Top             =   1560
      Width           =   1215
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Channel 0"
      Height          =   495
      Left            =   360
      TabIndex        =   7
      Top             =   1080
      Value           =   -1  'True
      Width           =   1215
   End
   Begin VB.VScrollBar VScroll1 
      Height          =   1215
      Left            =   3480
      Max             =   -1000
      Min             =   1000
      TabIndex        =   2
      Top             =   360
      Width           =   255
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Send"
      Height          =   375
      Left            =   360
      TabIndex        =   1
      Top             =   480
      Width           =   1215
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Left            =   2520
      TabIndex        =   0
      Text            =   "0"
      Top             =   480
      Width           =   615
   End
   Begin DlsrLib.DriverLINXSR dl 
      Left            =   240
      Top             =   3960
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label4 
      Caption         =   "Analog Output"
      Height          =   255
      Left            =   360
      TabIndex        =   6
      Top             =   120
      Width           =   1215
   End
   Begin VB.Label Label3 
      Caption         =   "Value"
      Height          =   255
      Left            =   2520
      TabIndex        =   5
      Top             =   120
      Width           =   615
   End
   Begin VB.Label Label2 
      Caption         =   "10 Volt"
      Height          =   255
      Left            =   3360
      TabIndex        =   4
      Top             =   120
      Width           =   735
   End
   Begin VB.Label Label1 
      Caption         =   "-10 Volt"
      Height          =   255
      Left            =   3360
      TabIndex        =   3
      Top             =   1680
      Width           =   735
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This is a simple example of how to set a plloed mode based, analog
'output operation using DriverLINX. This will take one sample and output
'the value to either chanel 0 or channel 1
Option Explicit

Private Sub Command1_Click()

Dim Chan As Integer ' Chan is the variable passed to the dl service request

If Option1.Value = True Then Chan = 0 'radio button for analog output channel 0 selection
If Option2.Value = True Then Chan = 1 'radio button for analog output channel 1 selection

Dim Volt As Double ' Volt is the variable passed to the DLVolts2Code function

Volt = Val(Text1.Text) 'convert text entry to a value

With dl 'this is the DriverLINX SR control
.Req_subsystem = DL_AO 'use the analog output subsystem
.Req_mode = DL_POLLED 'use polled mode output, Note, interrupt and DMA is unavailable for the KPCI-3102/04 card
.Req_op = DL_START 'operation to begin
.Evt_Str_type = DL_COMMAND 'start on command
.Evt_Stp_type = DL_TCEVENT 'stop when the number of output samples have been sent
.Sel_chan_start = Chan 'pass the variable for the start channel, you can set propert directly to 0, 1 and etc.
.Sel_chan_stop = Chan ' pass the variable for the top channel, you can set propert directly to 0, 1 and etc.
.Res_Sta_ioValue = dl.DLVolts2Code(Volt) 'pass value to card
.Sel_chan_N = 1 'only using one analog output channel at a time
.Sel_buf_N = 0 ' since the output is polled mode, no buffer has been selected
.Refresh 'start analog output operation
End With 'end this service request

showmessage dl 'show any errors

End Sub

Private Sub Form_Load()

With dl 'this is the DriverLINX SR control
.Req_op = DL_INITIALIZE 'initialize board
.Req_DLL_name = "*.dll" 'select the specifc card driver, use "KPCI3100" for KPCI-3102/04 card to eliminate the Open DriverLINX dialog box.
.Req_subsystem = DL_DEVICE 'select the correct subsystem
.Req_mode = DL_OTHER 'select the correct mode
.Refresh 'start initialize operation
End With 'end this service request

showmessage dl 'show any errors

End Sub

Sub showmessage(sr As Control) 'showmessage error call
If sr.Res_result <> DL_NoErr Then
sr.Req_op = DL_MESSAGEBOX
sr.Refresh
End If
End Sub

Private Sub VScroll1_Change()

Dim DecPlcs As Double 'dimension the varaible DecPlcs as a double
DecPlcs = 100 'set output to tenths

Text1.Text = VScroll1.Value / DecPlcs 'scale output to tenths

End Sub
